<?php
require 'db.php';

// Create referrals table
$create_referrals_table = "
CREATE TABLE IF NOT EXISTS `referrals` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `referrer_id` int(11) NOT NULL,
  `referred_id` int(11) NOT NULL,
  `referral_code` varchar(20) NOT NULL,
  `status` enum('pending','completed') DEFAULT 'pending',
  `bonus_paid` decimal(10,2) DEFAULT 0.00,
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `referred_id` (`referred_id`),
  KEY `referrer_id` (`referrer_id`),
  KEY `referral_code` (`referral_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
";

// Add referral_code column to users table if it doesn't exist
$add_referral_code_column = "
ALTER TABLE `users` 
ADD COLUMN IF NOT EXISTS `referral_code` varchar(20) UNIQUE DEFAULT NULL,
ADD COLUMN IF NOT EXISTS `referred_by` varchar(20) DEFAULT NULL,
ADD COLUMN IF NOT EXISTS `total_referrals` int(11) DEFAULT 0,
ADD COLUMN IF NOT EXISTS `total_referral_earnings` decimal(10,2) DEFAULT 0.00;
";

// Create referral_rewards table
$create_referral_rewards_table = "
CREATE TABLE IF NOT EXISTS `referral_rewards` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `referral_id` int(11) NOT NULL,
  `referrer_id` int(11) NOT NULL,
  `referred_id` int(11) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `type` enum('signup_bonus','recharge_bonus','game_bonus') DEFAULT 'signup_bonus',
  `status` enum('pending','paid','cancelled') DEFAULT 'pending',
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `referral_id` (`referral_id`),
  KEY `referrer_id` (`referrer_id`),
  KEY `referred_id` (`referred_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
";

// Execute the queries
if ($conn->query($create_referrals_table)) {
    echo "✅ Referrals table created successfully<br>";
} else {
    echo "❌ Error creating referrals table: " . $conn->error . "<br>";
}

if ($conn->query($add_referral_code_column)) {
    echo "✅ Referral columns added to users table successfully<br>";
} else {
    echo "❌ Error adding referral columns: " . $conn->error . "<br>";
}

if ($conn->query($create_referral_rewards_table)) {
    echo "✅ Referral rewards table created successfully<br>";
} else {
    echo "❌ Error creating referral rewards table: " . $conn->error . "<br>";
}

// Generate referral codes for existing users
$existing_users = $conn->query("SELECT id, username FROM users WHERE referral_code IS NULL");
if ($existing_users) {
    while ($user = $existing_users->fetch_assoc()) {
        $referral_code = strtoupper(substr($user['username'], 0, 3) . rand(1000, 9999));
        
        // Make sure code is unique
        $check_code = $conn->prepare("SELECT id FROM users WHERE referral_code = ?");
        $check_code->bind_param("s", $referral_code);
        $check_code->execute();
        while ($check_code->get_result()->num_rows > 0) {
            $referral_code = strtoupper(substr($user['username'], 0, 3) . rand(1000, 9999));
            $check_code->bind_param("s", $referral_code);
            $check_code->execute();
        }
        
        $update_code = $conn->prepare("UPDATE users SET referral_code = ? WHERE id = ?");
        $update_code->bind_param("si", $referral_code, $user['id']);
        if ($update_code->execute()) {
            echo "✅ Generated referral code for {$user['username']}: {$referral_code}<br>";
        }
    }
}

echo "<br>🎉 Referral system setup completed!<br>";
echo "<a href='index.php'>← Back to Home</a>";

$conn->close();
?> 